/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

public class SeaPersistence {
    private static final String SEA_DB = "Sea_DB";
    private static SeaPersistence instance;
    private RecordStore recordStore;
    private int[] scoreValues = new int[]{0, 0, 0};
    private String[] scoreNames = new String[]{"AAA", "BBB", "CCC"};
    private byte level = 0;

    public SeaPersistence() {
        this.load();
    }

    public String getScoreName(int n) {
        return this.scoreNames[n];
    }

    public int getScoreValue(int n) {
        return this.scoreValues[n];
    }

    public static SeaPersistence getInstance() {
        if (instance == null) {
            instance = new SeaPersistence();
        }
        return instance;
    }

    public void load() {
        try {
            if (this.recordStore == null) {
                this.recordStore = RecordStore.openRecordStore((String)SEA_DB, (boolean)true);
            }
            if (this.recordStore != null && this.recordStore.getNumRecords() > 0) {
                this.unpack(this.recordStore.getRecord(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean save() {
        boolean bl = false;
        if (this.recordStore != null) {
            byte[] byArray = this.pack();
            try {
                if (this.recordStore.getNumRecords() == 0) {
                    this.recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    this.recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public void setScore(String string, int n) {
        byte by = (byte)string.length();
        int n2 = 0;
        while (n2 < 3 - by) {
            string = string + " ";
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.scoreValues.length) {
            if (this.scoreValues[n3] < n) {
                int n4 = this.scoreValues.length - 1;
                while (n4 > n3) {
                    this.scoreNames[n4] = this.scoreNames[n4 - 1];
                    this.scoreValues[n4] = this.scoreValues[n4 - 1];
                    --n4;
                }
                this.scoreNames[n3] = string;
                this.scoreValues[n3] = n;
                n3 = this.scoreValues.length;
            }
            ++n3;
        }
        this.save();
    }

    public void close() {
        if (this.recordStore != null) {
            try {
                this.recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void resetRecordStore(String string) throws Exception {
        RecordStore.deleteRecordStore((String)string);
    }

    public int getScoreNumber() {
        return this.scoreNames.length;
    }

    private byte[] pack() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = 0;
            n = 0;
            while (n < this.scoreNames.length) {
                dataOutputStream.writeUTF(this.scoreNames[n]);
                ++n;
            }
            n = 0;
            while (n < this.scoreValues.length) {
                dataOutputStream.writeInt(this.scoreValues[n]);
                ++n;
            }
            byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private void unpack(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = 0;
            n = 0;
            while (n < this.scoreNames.length) {
                this.scoreNames[n] = dataInputStream.readUTF();
                ++n;
            }
            n = 0;
            while (n < this.scoreValues.length) {
                this.scoreValues[n] = dataInputStream.readInt();
                ++n;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

